/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.mixin;

import net.adventurez.init.ConfigInit;
import net.adventurez.init.ItemInit;
import net.adventurez.item.armor.GildedNetheriteArmor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    public PlayerEntityMixin(EntityType<Player> type, Level world) {
        super(type, world);
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;dropShoulderEntities()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void damageMixin(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (this.m_6844_(EquipmentSlot.CHEST).m_41720_() == ItemInit.GILDED_NETHERITE_CHESTPLATE && GildedNetheriteArmor.fullGolemArmor((Player)this)) {
            if (this.m_9236_().m_213780_().m_188501_() <= ConfigInit.CONFIG.gilded_netherite_armor_dodge_chance) {
                info.setReturnValue((Object)false);
            } else if (source.m_269533_(DamageTypeTags.f_268745_) && !GildedNetheriteArmor.isStoneGolemArmorActive(this.m_6844_(EquipmentSlot.CHEST))) {
                GildedNetheriteArmor.activateStoneGolemArmor((Player)this, this.m_6844_(EquipmentSlot.CHEST));
                info.setReturnValue((Object)false);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean m_6051_() {
        ItemStack golemChestplate = this.m_6844_(EquipmentSlot.CHEST);
        boolean fireActivated = this.m_6844_(EquipmentSlot.CHEST).m_41720_().equals(ItemInit.GILDED_NETHERITE_CHESTPLATE) && GildedNetheriteArmor.isStoneGolemArmorActive(golemChestplate);
        return this.m_6060_() && !this.m_5833_() && !fireActivated;
    }
}

